var Sequelize = require('sequelize'),
    fs = require('fs'),
    parametersDB = JSON.parse(fs.readFileSync(__dirname + '/../parameters.json')).databaseConfiguration,
    sequelize = new Sequelize(parametersDB.databaseName, parametersDB.username, parametersDB.password, parametersDB.details);

// load models
var models = [
//    'User',
//    'Task',
    'UserNote',
    'GroupNote',
    'NoteDetails',
//    'Group',
    'Book',
    'BookState',
//    'GroupUser',
    'Log',
    'UserNotesQuantity'
];
models.forEach(function(model) {
    module.exports[model] = sequelize.import(__dirname + '/' + model);
});

// describe relationships
(function(m) {
//    m.Book.hasMany(m.Task, { foreignKey: 'book_id' });
//    m.User.hasMany(m.Task, { foreignKey: 'user_id' });

//    m.User.hasMany(m.UserNote, { foreignKey: 'user_id' });
//    m.Group.hasMany(m.GroupNote, { foreignKey: 'group_id' });

    m.Book.hasMany(m.UserNote, { foreignKey: 'book_id' });
    m.Book.hasMany(m.GroupNote, { foreignKey: 'book_id' });

    m.Book.hasMany(m.BookState, { foreignKey: 'book_id' });

    sequelize.sync().complete(function(err) {
        if (err) {
            throw err
        } else {
            console.log('Express server listening');
//            indexUserIdOnUserNotes();
            var index = 0;

            function createErrorForIndexing(error) {
                index++;
                console.log(index);
                return {name: "IndexingFieldsError", message: error};
            }

            function indexUserIdOnUserNotes() {
                sequelize.query("CREATE INDEX user_id_idx ON usernotes(user_id)")
                    .success(function() {
                        indexNoteIdOnUserNotes();
                    })
                    .error(function(error) {
                        throw createErrorForIndexing(error);
                    });
            }

            function indexNoteIdOnUserNotes() {
                sequelize.query("CREATE INDEX note_id_idx ON usernotes(note_id)")
                    .success(function() {
                        indexProductcodeOnBooks();
                    })
                    .error(function(error) {
                        throw createErrorForIndexing(error);
                    });
            }

            function indexProductcodeOnBooks() {
                sequelize.query("CREATE INDEX productcode_idx ON books(productcode)")
                    .success(function() {
                        indexUserIdAndBookIdOnBooksStates();
                    })
                    .error(function(error) {
                        throw createErrorForIndexing(error);
                    });
            }

            function indexUserIdAndBookIdOnBooksStates() {
                sequelize.query("CREATE INDEX bookstate_idx ON bookstates(user_id, book_id)")
                    .success(function() {
                        indexGroupIdOnGroupNotes();
                    })
                    .error(function(error) {
                        throw createErrorForIndexing(error);
                    });
            }

            function indexGroupIdOnGroupNotes() {
                sequelize.query("CREATE INDEX group_id_idx ON groupnotes(group_id)")
                    .success(function() {
                        indexNoteIdOnGroupNotes();
                    })
                    .error(function(error) {
                        throw createErrorForIndexing(error);
                    });
            }

            function indexNoteIdOnGroupNotes() {
                sequelize.query("CREATE INDEX note_id_idx ON groupnotes(note_id)")
                    .success(function() {
                        indexUserIdOnUserNotesQuantity();
                    })
                    .error(function(error) {
                        throw createErrorForIndexing(error);
                    });
            }

            function indexUserIdOnUserNotesQuantity() {
                sequelize.query("CREATE INDEX user_id_idx ON usernotes_quantity(user_id)")
                    .success(function() {
                    })
                    .error(function(error) {
                        throw createErrorForIndexing(error);
                    });
            }
        }
    });
})(module.exports);

// export connection
module.exports.sequelize = sequelize;